<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Headers: Content-Type');

require_once 'db.php';

$response = [
    'success' => false,
    'message' => '',
    'data' => []
];

try {
    // Main query to get all active blog categories
    $query = "SELECT * FROM blog_category WHERE delete_status='0'";
    $result = mysqli_query($conn, $query);
    
    if (!$result) {
        throw new Exception('Database error: ' . mysqli_error($conn));
    }

    $data = array();
    
    while ($row = mysqli_fetch_assoc($result)) {
        $id = $row['id'];
        
        // Count related blogs for each category
        $query1 = "SELECT COUNT(*) as blog_count FROM blogs WHERE category='$id' AND delete_status='0'";
        $result1 = mysqli_query($conn, $query1);
        
        if (!$result1) {
            throw new Exception('Database error: ' . mysqli_error($conn));
        }
        
        $fetch1 = mysqli_fetch_assoc($result1);
        $row['blog_count'] = (int)$fetch1['blog_count'];
        
        $data[] = $row;
    }

    $response = [
        'success' => true,
        'message' => 'Categories fetched successfully',
        'data' => $data,
        'count' => count($data)
    ];

} catch (Exception $e) {
    $response['message'] = $e->getMessage();
    http_response_code(500); // Internal Server Error
}

// Close conn
if (isset($conn)) {
    mysqli_close($conn);
}

echo json_encode($response);
?>